/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper.gui;

import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.gui.CustomGuiButtonWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiEntityWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiItemSlotWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiLabelWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiScrollWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTextFieldWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTexturedRectWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTimerWrapper;

public abstract class CustomGuiComponentWrapper
implements ICustomGuiComponent {
    String[] hoverText;
    IItemStack hoverStack;
    int id;
    int posX;
    int posY;
    int offsetType;

    public static CustomGuiComponentWrapper createFromNBT(NBTTagCompound nbt) {
        switch (nbt.func_74762_e("type")) {
            case 0: {
                return new CustomGuiButtonWrapper().fromNBT(nbt);
            }
            case 1: {
                return new CustomGuiLabelWrapper().fromNBT(nbt);
            }
            case 2: {
                return new CustomGuiTexturedRectWrapper().fromNBT(nbt);
            }
            case 3: {
                return new CustomGuiTextFieldWrapper().fromNBT(nbt);
            }
            case 4: {
                return new CustomGuiScrollWrapper().fromNBT(nbt);
            }
            case 5: {
                return new CustomGuiItemSlotWrapper().fromNBT(nbt);
            }
            case 6: {
                return new CustomGuiTimerWrapper().fromNBT(nbt);
            }
            case 7: {
                return new CustomGuiEntityWrapper().fromNBT(nbt);
            }
        }
        return null;
    }

    public CustomGuiComponentWrapper fromNBT(NBTTagCompound nbt) {
        this.setId(nbt.func_74762_e("id"));
        this.setPos(nbt.func_74759_k("pos")[0], nbt.func_74759_k("pos")[1]);
        if (nbt.func_74764_b("hover")) {
            NBTTagList list = nbt.func_150295_c("hover", 8);
            String[] hoverText = new String[list.func_74745_c()];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                hoverText[i] = ((NBTTagString)list.func_179238_g(i)).func_150285_a_();
            }
            this.setHoverText(hoverText);
        }
        if (nbt.func_74764_b("hoverStack")) {
            this.setHoverStack(Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(new ItemStack(nbt.func_74775_l("hoverStack"))));
        }
        return this;
    }

    @Override
    public String[] getHoverText() {
        return this.hoverText;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getPosX() {
        return this.posX;
    }

    @Override
    public int getPosY() {
        return this.posY;
    }

    public abstract int getType();

    @Override
    public boolean hasHoverText() {
        return this.hoverStack != null || this.hoverText != null && this.hoverText.length > 0;
    }

    @Override
    public void offSet(int type) {
        if (type < 0) {
            type *= -1;
        }
        this.offsetType = type % 4;
    }

    @Override
    public IItemStack getHoverStack() {
        return this.hoverStack;
    }

    @Override
    public ICustomGuiComponent setHoverStack(IItemStack item) {
        this.hoverStack = item;
        return this;
    }

    @Override
    public ICustomGuiComponent setHoverText(String text) {
        this.hoverText = new String[]{text};
        return this;
    }

    @Override
    public ICustomGuiComponent setHoverText(String[] text) {
        this.hoverText = text;
        return this;
    }

    @Override
    public ICustomGuiComponent setId(int idIn) {
        this.id = idIn;
        return this;
    }

    @Override
    public ICustomGuiComponent setPos(int x, int y) {
        this.posX = x;
        this.posY = y;
        return this;
    }

    public NBTTagCompound toNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("id", this.id);
        nbt.func_74783_a("pos", new int[]{this.posX, this.posY});
        if (this.hoverText != null) {
            NBTTagList list = new NBTTagList();
            for (String s : this.hoverText) {
                if (s == null || s.isEmpty()) continue;
                list.func_74742_a((NBTBase)new NBTTagString(s));
            }
            if (list.func_74745_c() > 0) {
                nbt.func_74782_a("hover", (NBTBase)list);
            }
        }
        if (this.hoverStack != null && !this.hoverStack.isEmpty()) {
            nbt.func_74782_a("hoverStack", (NBTBase)this.hoverStack.getMCItemStack().func_77955_b(new NBTTagCompound()));
        }
        nbt.func_74768_a("type", this.getType());
        return nbt;
    }
}

